{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 08.01.99 - 12:10:49 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMAVI, MMCstDlg, MMDIB, MMGauge;

type
  TForm1 = class(TForm)
    OpenDialog: TMMAVIOpenDialog;
    AVIFile: TMMAVIFile;
    btnLoad: TButton;
    btnSplit: TButton;
    Gauge: TMMGauge;
    AVICompressor: TMMAVICompressor;
    procedure btnLoadClick(Sender: TObject);
    procedure btnSplitClick(Sender: TObject);
    procedure AVICompressorSave(Sender: TObject; Percent: Integer; var Abort: Boolean);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.btnLoadClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      { close a previous loaded file }
      AVIFile.CloseFile;

      { set the filename }
      AVIFile.FileName := OpenDialog.FileName;

      { open the file }
      AVIFile.OpenFile;

      btnSplit.Enabled := (AVIFile.StreamCount > 0);
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnSplitClick(Sender: TObject);
var
   i               : integer;
   VideoStream     : TMMAVIStream;
   AudioStream     : TMMAVIStream;
   NewVideoStream  : TMMAVIStream;
   ReadVideoWorker : TMMAVIVideoWorker;
   WriteVideoWorker: TMMAVIVideoWorker;
   pd              : PDIB;
   Bitmap          : TBitmap;
   H               : HBitmap;
   Pal             : HPAlette;

   FName: string;

begin
   { get the first video stream }
   VideoStream := AVIFile.TypedStreams[stVideo,0];

   { get the first audio stream }
   AudioStream := AVIFile.TypedStreams[stAudio,0];
   try
      Screen.Cursor  := crHourGlass;

      Gauge.Progress := 0;
      Gauge.Visible  := True;

      FName := ExtractFilePath(AVIFile.FileName)+ChangeFileExt(ExtractFileName(AVIFile.FileName),'');

      { create a temporary stream }
      NewVideoStream := AVICreateVideoStream(Round(VideoStream.FrameRate));
      try
         { create the Video Workers to access the video stream }
         ReadVideoWorker  := TMMAVIVideoWorker.Create(VideoStream);
         WriteVideoWorker := TMMAVIVideoWorker.Create(NewVideoStream);
         try
            Bitmap := TBitmap.Create;
            ReadVideoWorker.BeginReading(nil);
            try
               Gauge.Caption  := 'Reading ';
               Gauge.MaxValue := VideoStream.Length;
               Gauge.Progress := 0;
               Gauge.Visible  := True;

               for i := 0 to VideoStream.Length-1 do
               begin
                  DIB_DIBToBitmap(ReadVideoWorker.DIB[i], H, Pal);
                  Bitmap.Handle  := H;
                  Bitmap.Palette := Pal;

                  Bitmap.Canvas.Font.Color := clRed;
                  Bitmap.Canvas.TextOut(0,0,'Frame: '+IntToStr(i));
                  pd := DIB_BitmapToDIB(Bitmap.Handle, Pal, 16, 1);
                  WriteVideoWorker.DIB[i] := pd;
                  GlobalFreePtr(pd);

                  Gauge.Progress := i;
               end;

            finally
               ReadVideoWorker.EndReading;
               Bitmap.Free;
            end;

         finally
            ReadVideoWorker.Free;
            WriteVideoWorker.Free;
         end;

         Gauge.Caption  := 'Writing ';
         Gauge.MaxValue := 100;
         Gauge.Progress := 0;

         AVICompressor.AddStream(NewVideoStream);
         AVICompressor.AddStream(AudioStream);
         AVICompressor.SaveToFile(FName+'_new.avi');
         AVICompressor.FreeStreams;

      finally
         Gauge.Visible  := False;

         { close the temporary stream }
         AVICloseStream(NewVideoStream);
      end;

   finally
      Gauge.Visible := False;
      Screen.Cursor := crDefault;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.AVICompressorSave(Sender: TObject; Percent: Integer; var Abort: Boolean);
begin
   Gauge.Progress := Percent;
end;

end.
